//
//  MCPGCoreServer.h
//  MCPostgresPersistence
//
//  Created by Michael Clark on 23/08/08.
//  Copyright 2008 Marketcircle Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <MCFoundation/NSObject+MCAdditions.h>
#import <CoreServices/CoreServices.h>

#import "MCPostgresDefines.h"

extern NSString*  kMCPGServerDefaultDataPathFormat;

typedef enum {
	MCPGCoreServerModeEmbeddedPostgresServer,
	MCPGCoreServerModeRemotePostgresServer
} MCPGCoreServerOperationMode;

// Method for passing the server class details about the datapath
//  These affect the parameters passed to initdb
//   see initdb --help for details about these settings
typedef struct _MCPGDataPathSettings {
	BOOL          cleanUpAfterFailure;
	
	NSString*     encoding;
	NSString*     locale;
	NSString*     authMethod; // if nil no auth is setup - if an auth is provided then passwordFilePath must be set
	NSString*     passwordFilePath;
	NSString*     username;
    
    NSString*     logFile;  // the file (including path to file) where various bits get logged to on the lowlevel - mainly  pg_ctl
} MCPGDataPathSettings;



extern MCPGDataPathSettings MCPGMakeEmptyDataPathSettings();

@interface MCPGCoreServer : NSObject {
	MCPGCoreServerOperationMode	  mode;
	int                   serverPID;
	
	NSString*             dataPath;
	NSString*             hostName;
	int                   portNumber;

	MCPGDataPathSettings  dataPathSettings;
	
	NSString*             logPath;
	int                   maxLogs;
	
	id                    delegate;
	
}

@property (nonatomic, readonly) MCPGCoreServerOperationMode mode;

#pragma mark -
#pragma mark Singleton
+ (id)defaultServer;
  // Defaults the data path to ~/Library/Application Support/MCPostgress/<PROCESSNAME>/
  //  Sets up a default MCPGDataPathSettings structure with minimal options
+ (id)defaultServerForDataPath: (NSString*)aDataPath dataPathSettings: (MCPGDataPathSettings)aDataPathSettings;


#pragma mark -
#pragma mark Factory Class
+ (Class)defaultServerClass;
+ (void)setDefaultServerClass: (Class)aClass;

#pragma mark -
#pragma mark Initialization
- (id)initWithDataPath: (NSString*)aDataPath dataPathSettings: (MCPGDataPathSettings)aDataPathSettings;

- (BOOL)initializeDataPathAndReturnError: (NSError**)error;

#pragma mark -
#pragma mark State Methods
- (BOOL)isDataPathInitialized;
- (BOOL)isRunning;
- (int)serverPID;

#pragma mark -
#pragma mark Start/Stop
- (BOOL)startWithOptions:(NSArray *)pg_options error: (NSError**)error;
- (BOOL)startAndReturnError: (NSError**)error; // calls above with nil options
- (BOOL)stopWithMode: (MCPGServerStopMode)mode waitForReturn: (BOOL)waitFlag error: (NSError**)error;
- (BOOL)stopAndReturnError: (NSError**)error; // calls above with smart mode and YES to wait - waits for clients to disconnect
- (BOOL)restartWithMode:(MCPGServerStopMode)mode options:(NSArray *)pg_options error:(NSError **)error;
- (BOOL)restartAndReturnError:(NSError **)error; // calls above with nil options


#pragma mark -
#pragma mark Server Admin
- (NSString*)pathForPGTool: (NSString*)tool;
- (BOOL)createDatabaseNamed: (NSString*)aDatabaseName error: (NSError**)error;
  // Uses the dataPathSettings to populate options for the createdb command

#pragma mark -
#pragma mark Accessors
- (NSString *)dataPath;
- (void)setDataPath:(NSString *)aDataPath;

- (NSString *)hostName;
- (void)setHostName:(NSString *)anHostName;

- (int)portNumber;
- (void)setPortNumber:(int)aPortNumber;

- (NSString *)logPath;
- (void)setLogPath:(NSString *)aLogPath;

- (int)maxLogs;
- (void)setMaxLogs:(int)aMaxLogs;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

@end
